/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: InformationDialog.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 21.03.07 17:50 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Basic Information Dialog for displaying Driver/Channel Information
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        30.06.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file InformationDialog.cpp
///   Basic Information Dialog for displaying Driver/Channel Information
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "InformationDialog.h"
#include ".\informationdialog.h"
#include "CifXTestDlg.h"


IMPLEMENT_DYNAMIC(CInformationDialog, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CInformationDialog::CInformationDialog(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CInformationDialog::IDD, pParent, false)
  , m_eType(eDRIVERINFO)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CInformationDialog::~CInformationDialog()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CInformationDialog::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_PROPERTYLIST, m_cPropertyListCtrl);
  DDX_Control(pDX, IDC_CB_SELECTION, m_cAdditionalSelection);
}


BEGIN_MESSAGE_MAP(CInformationDialog, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_UPDATE, OnBnClickedBtnUpdate)
  ON_CBN_SELCHANGE(IDC_CB_SELECTION, OnCbnSelchangeCbSelection)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// Update Button clicked event
/////////////////////////////////////////////////////////////////////////////
void CInformationDialog::OnBnClickedBtnUpdate()
{
  UpdateValues();
}

/////////////////////////////////////////////////////////////////////////////
/// First Time dialog initialization, Set up columns of list control
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CInformationDialog::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  CRect rectWnd;
  m_cPropertyListCtrl.GetWindowRect(rectWnd);

  int iWidth = rectWnd.Width() - GetSystemMetrics(SM_CXVSCROLL) - 2 * GetSystemMetrics(SM_CXEDGE);

  m_cPropertyListCtrl.InsertColumn(0, _T("Property"), LVCFMT_LEFT, iWidth / 2);
  m_cPropertyListCtrl.InsertColumn(1, _T("Value"),    LVCFMT_LEFT, iWidth / 2);

  m_cPropertyListCtrl.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Updates all Properties inside list control
/////////////////////////////////////////////////////////////////////////////
void CInformationDialog::UpdateValues()
{
  GetDlgItem(IDC_STATIC_CAPTION)->SetWindowText(m_csCaption);

  m_cPropertyListCtrl.DeleteAllItems();

  CCifXDeviceBase::PROPERTY_VECTOR cvProperties;
  switch(m_eType)
  {
  case eDRIVERINFO:
    cvProperties = CCifXDeviceBase::GetDriverInformation();
    break;

  case eCHANNELINFO:
    {
      int   iCurSel = m_cAdditionalSelection.GetCurSel();
      ULONG ulCmd = (ULONG)m_cAdditionalSelection.GetItemData(iCurSel);

      cvProperties = CcifXTestDlg::s_pcDevice->GetChannelInformation(ulCmd);
    }
    break;

  }

  for(int iIdx = 0; iIdx < (int)cvProperties.size(); ++iIdx)
  {
    m_cPropertyListCtrl.InsertItem(iIdx, cvProperties[iIdx].csProperty);
    m_cPropertyListCtrl.SetItemText(iIdx, 1, cvProperties[iIdx].csValue);
  }
}

void CInformationDialog::OnCbnSelchangeCbSelection()
{
  UpdateValues();
}

void CInformationDialog::SetType(PROPERTY_TYPE eType)
{                                       
  if(eType == eCHANNELINFO)
  {
    m_cAdditionalSelection.ShowWindow(SW_SHOW);
    m_cAdditionalSelection.ResetContent();

    if(CcifXTestDlg::s_pcDevice->IsSystemDevice())
    { 
      for(int iIdx = 0; iIdx < sizeof(SYSCHANNEL_INFOS) / sizeof(SYSCHANNEL_INFOS[0]); ++iIdx)
      {
        int iItem = m_cAdditionalSelection.AddString(SYSCHANNEL_INFOS[iIdx].szInfo);
        m_cAdditionalSelection.SetItemData(iItem, SYSCHANNEL_INFOS[iIdx].ulInfo);
      }
    } else
    {
      for(int iIdx = 0; iIdx < sizeof(CHANNEL_INFOS) / sizeof(CHANNEL_INFOS[0]); ++iIdx)
      {
        int iItem = m_cAdditionalSelection.AddString(CHANNEL_INFOS[iIdx].szInfo);
        m_cAdditionalSelection.SetItemData(iItem, CHANNEL_INFOS[iIdx].ulInfo);
      }      
    }

    m_cAdditionalSelection.SetCurSel(0);

  } else
  {
    m_cAdditionalSelection.ShowWindow(SW_HIDE);
  }

  m_eType = eType; 
  UpdateValues();
}
